/* 
 *  RemoveIntrinsicRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;

public class RemoveIntrinsicRequest extends InteractionRequest {

    private static final Logger LOG = Logger.getLogger(RemoveIntrinsicRequest.class);
    private final String intrinsicName;

    public RemoveIntrinsicRequest(String interactionID, String intrinsicName) {
        super(LOG, interactionID);
        this.intrinsicName = intrinsicName;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        getInteraction().removeIntrinsic(intrinsicName);
        LOG.trace(methodName + "-");
        return null;
    }
}
